using System;
using Server;
using Server.Items;

namespace Server.Items
{
	public class Bryle : BaseArmor
	{
		public override int ArtifactRarity{ get{ return 100; } }
		
		public override int BasePhysicalResistance{ get{ return 3; } }
		public override int BaseFireResistance{ get{ return 4; } }
		public override int BaseColdResistance{ get{ return 4; } }
		public override int BasePoisonResistance{ get{ return 4; } }
		public override int BaseEnergyResistance{ get{ return 4; } }

		public override int InitMinHits{ get{ return 125; } }
		public override int InitMaxHits{ get{ return 125; } }

		public override int AosStrReq{ get{ return 10; } }
		public override int OldStrReq{ get{ return 10; } }

		public override int ArmorBase{ get{ return 25; } }

		public override ArmorMaterialType MaterialType{ get{ return ArmorMaterialType.Chainmail; } }
		public override ArmorMeditationAllowance DefMedAllowance{ get{ return ArmorMeditationAllowance.All; } }

		[Constructable]
		public Bryle() : base( 0x3172 )
		{
			Weight = 3.0;
			Name = "Bryle";
			Hue = 1167;
			LootType = LootType.Blessed;
			ArmorAttributes.MageArmor = 1;
			ArmorAttributes.SelfRepair = 5;
			Attributes.AttackChance = 10;
			Attributes.BonusDex = 6;
			Attributes.BonusHits = 10;
			Attributes.BonusInt = 6;
			Attributes.BonusMana = 10;
			Attributes.BonusStam = 10;
			Attributes.BonusStr = 6;
			Attributes.CastRecovery = 3;
			Attributes.CastSpeed = 3;
			Attributes.LowerManaCost = 10;
			Attributes.Luck = 300;
			Attributes.NightSight = 1;
			Attributes.RegenHits = 2;
			Attributes.RegenMana = 3;
			Attributes.RegenStam = 2;
			
			SkillBonuses.SetValues( 0, SkillName.Anatomy, 10.0 );
		}
		
		private void ClearTransform( Mobile m )
		{
			m.BodyMod = 0;
			m.HueMod = -1;
			
			Attributes.BonusStr = 6;
			Attributes.BonusHits = 10;
			Attributes.RegenHits = 2;
			Attributes.RegenStam = 2;
			Attributes.AttackChance = 10;
			Attributes.DefendChance = 0;
			SkillBonuses.SetValues( 0, SkillName.Anatomy, 10.0 );
		}
		
		private void Transform( Mobile m )
		{
			m.SendMessage( "Citis ze se tve telo meni." );
			m.BodyMod = 318;
			m.HueMod = -1;
			
			Attributes.BonusStr = 26;
			Attributes.BonusHits = 20;
			Attributes.RegenHits = 6;
			Attributes.RegenStam = 6;
			Attributes.AttackChance = 20;
			Attributes.DefendChance = 35;
			SkillBonuses.SetValues( 0, SkillName.Anatomy, 30.0 );
			
			m.PlaySound( 358 );
			m.FixedParticles( 0x376A, 1, 14, 0x13B5, EffectLayer.Waist );
		}

		public override void OnDoubleClick( Mobile m )
		{
			if( m.HasTrade )
			{
				m.SendMessage( "Nemuzes predmet pouzit pokud s nekym obchodujes!" );
			}
			else
			{
				if( Parent == m )
				{
					if ( BraceletofMinax.CheckTransform(  m, 318 ) )
					{
						if( m.IsBodyMod && m.BodyMod == 318 ) //z vlka na cloveka
						{
							//                   ClearTransform( m );
							m.RemoveItem(this);
							m.EquipItem(this);
							m.PlaySound( 0x511 );
							m.FixedParticles( 0x376A, 1, 14, 0x13B5, EffectLayer.Waist );
							m.SendMessage( "Ucinek skoncil" );
						}
						else //na vlka
						{
							m.RemoveItem(this);
							Transform( m );
							m.EquipItem(this);
						}
					}
				}
				else if ( IsChildOf( m.Backpack ) )
				{
					if( this.ItemID == 5201 ) this.ItemID = 5128;
					else if( this.ItemID == 5128 ) this.ItemID = 5130;
					else if( this.ItemID == 5130 ) this.ItemID = 5132;
					else if( this.ItemID == 5132 ) this.ItemID = 5134;
					else if( this.ItemID == 5134 ) this.ItemID = 5138;
					else if( this.ItemID == 5138 ) this.ItemID = 5051;
					else if( this.ItemID == 5051 ) this.ItemID = 10101;
					else if( this.ItemID == 10101 ) this.ItemID = 10100;
					else if( this.ItemID == 10100 ) this.ItemID = 10113;
					else if( this.ItemID == 10113 ) this.ItemID = 10116;
					else if( this.ItemID == 10116 ) this.ItemID = 10102;
					else if( this.ItemID == 10102 ) this.ItemID = 10117;
					else if( this.ItemID == 10117 ) this.ItemID = 10104;
					else if( this.ItemID == 10104 ) this.ItemID = 10126;
					else if( this.ItemID == 10126 ) this.ItemID = 5908;
					else if( this.ItemID == 5908 ) this.ItemID = 5910;
					else if( this.ItemID == 5910 ) this.ItemID = 5911;
					else if( this.ItemID == 5911 ) this.ItemID = 5912;
					else if( this.ItemID == 5912 ) this.ItemID = 5916;
					else if( this.ItemID == 5916 ) this.ItemID = 5907;
					else if( this.ItemID == 5907 ) this.ItemID = 5914;
					else if( this.ItemID == 5914 ) this.ItemID = 5915;
					else if( this.ItemID == 5915 ) this.ItemID = 5440;
					else if( this.ItemID == 5440 ) this.ItemID = 0x3172;
					else if( this.ItemID == 0x3172 ) this.ItemID = 5201;
					
					Weight = 3.0;
				}
			}
		}
		
		public override void OnRemoved(object parent)
		{
			base.OnRemoved( parent );
			
			if (parent is Mobile)
			{
				Mobile m = (Mobile)parent;
				if( m.BodyMod == 318 ) //z demona na cloveka
					ClearTransform( m );
			}
		}
		
		public override void GetProperties(ObjectPropertyList list)
		{
			base.GetProperties(list);
			
			list.Add( "<basefont color=#33FF66>Transform to Dark Father<basefont color=White>" );
		}

		public Bryle( Serial serial ) : base( serial )
		{
		}
		
		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( (int) 0 );
		}
		
		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();
			
			if( Parent is Mobile )
			{
				((Mobile)Parent).BodyMod = 0;
				((Mobile)Parent).HueMod = -1;
				
				Attributes.BonusStr = 6;
				Attributes.BonusHits = 10;
				Attributes.RegenHits = 2;
				Attributes.RegenStam = 2;
				Attributes.AttackChance = 10;
				Attributes.DefendChance = 0;
				SkillBonuses.SetValues( 0, SkillName.Anatomy, 10.0 );
			}
		}
	}
}
